#ifndef PIXEL_H
#define PIXEL_H

#include "types.h"

class Pixel
{
public:
	Pixel();
	Pixel(UInt32);
	~Pixel();

	UInt32 getPixel()	const	{return myPixel;}
	int getRed()		const	{return (int)((myPixel & 0xFF000000) >> 24);}
	int getGreen()		const	{return (int)((myPixel & 0x00FF0000) >> 16);}
	int getBlue()		const	{return (int)((myPixel & 0x0000FF00) >> 8);}
	int getAlpha()		const	{return (int)((myPixel & 0x000000FF));}	

	COLOR getColor();

private:
	UInt32 myPixel;
};

#endif